<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Meiwa Campaign</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/stisla/dist/modules/bootstrap-social/bootstrap-social.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/stisla/dist/css/style.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/stisla/dist/css/components.css">
  <style>
    :root { --meiwa-green: #25D366; }
    .navbar-bg { background-color: var(--meiwa-green) !important; }
    .btn-primary, .btn-success { background-color: var(--meiwa-green); border-color: var(--meiwa-green); }
    .text-brand { color: var(--meiwa-green); }
    .section .section-header h1 { color: var(--meiwa-green); }
    .table thead th { background: var(--meiwa-green); color: #fff; }
    footer { color: #6c757d; }
  </style>
</head>
<body>
  <div id="app">
    <div class="main-wrapper">
      <div class="navbar-bg"></div>
      <nav class="navbar navbar-expand-lg main-navbar">
        <a class="navbar-brand text-white" href="{{ route('dashboard') }}">Meiwa Campaign</a>
        <ul class="navbar-nav navbar-right ml-auto">
          <li class="nav-item"><a href="{{ route('reports.list') }}" class="nav-link text-white"><i class="fas fa-chart-bar"></i></a></li>
          <li class="nav-item dropdown">
            <a href="#" data-toggle="dropdown" class="nav-link dropdown-toggle text-white"><i class="far fa-user"></i> {{ auth()->user()->name ?? 'User' }}</a>
            <div class="dropdown-menu dropdown-menu-right">
              <a class="dropdown-item" href="{{ route('campaigns.index') }}">Campaigns</a>
              <a class="dropdown-item" href="{{ route('branding.user') }}">Branding</a>
              @can('admin-only')
              <div class="dropdown-divider"></div>
              <a class="dropdown-item" href="{{ route('admin.users') }}">Admin: Users</a>
              <a class="dropdown-item" href="{{ route('admin.endpoints') }}">Admin: Endpoints</a>
              <a class="dropdown-item" href="{{ route('admin.settings') }}">Admin: Settings</a>
              <a class="dropdown-item" href="{{ route('admin.branding') }}">Admin: Branding</a>
              @endcan
              <div class="dropdown-divider"></div>
              <form method="POST" action="/logout">@csrf<button class="dropdown-item text-danger">Logout</button></form>
            </div>
          </li>
        </ul>
      </nav>

      <div class="main-sidebar">
        <aside id="sidebar-wrapper">
          <div class="sidebar-brand"><a href="{{ route('dashboard') }}">Meiwa</a></div>
          <ul class="sidebar-menu">
            <li><a class="nav-link" href="{{ route('dashboard') }}"><i class="fas fa-home"></i><span>Dashboard</span></a></li>
            <li><a class="nav-link" href="{{ route('campaigns.index') }}"><i class="fas fa-bullhorn"></i><span>Campaign</span></a></li>
            <li><a class="nav-link" href="{{ route('reports.list') }}"><i class="fas fa-chart-bar"></i><span>Laporan</span></a></li>
            @can('admin-only')
              <li class="menu-header">Admin</li>
              <li><a class="nav-link" href="{{ route('admin.users') }}"><i class="fas fa-users-cog"></i><span>User</span></a></li>
              <li><a class="nav-link" href="{{ route('admin.endpoints') }}"><i class="fas fa-plug"></i><span>Endpoint</span></a></li>
              <li><a class="nav-link" href="{{ route('admin.settings') }}"><i class="fas fa-cog"></i><span>Settings</span></a></li>
              <li><a class="nav-link" href="{{ route('admin.branding') }}"><i class="fas fa-image"></i><span>Branding</span></a></li>
            @endcan
          </ul>
        </aside>
      </div>

      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1>@yield('title')</h1>
          </div>
          <div class="section-body">
            @if (session('ok'))
              <div class="alert alert-success">{{ session('ok') }}</div>
            @endif
            @if ($errors->any())
              <div class="alert alert-danger">
                <ul class="mb-0">@foreach ($errors->all() as $e)<li>{{ $e }}</li>@endforeach</ul>
              </div>
            @endif
            @yield('content')
          </div>
        </section>
      </div>

      <footer class="main-footer text-center">
        <div class="footer-left">© {{ date('Y') }}</div>
        <div class="footer-right">{{ \App\Models\Setting::get('footer_text','Meiwa Cloud API') }}</div>
      </footer>
    </div>
  </div>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/stisla/dist/js/stisla.js"></script>
</body>
</html>
