@extends('layouts.app')
@section('title','Upload / Import')
@section('content')
<div class="card">
  <div class="card-body">
    <p><b>Campaign:</b> {{ $campaign->name }}</p>
    <form method="post" action="{{ route('campaigns.upload.store',$campaign->id) }}" enctype="multipart/form-data">
      @csrf
      @if ($campaign->source_type === 'upload')
        <div class="form-group">
          <label>Upload CSV</label>
          <input type="file" name="file" class="form-control" required>
        </div>
      @else
        <div class="form-group">
          <label>URL Google Sheets</label>
          <input type="url" name="sheets_url" class="form-control" placeholder="https://docs.google.com/spreadsheets/d/..." required>
          <small class="text-muted">Pastikan sharing: Anyone with link (Viewer)</small>
        </div>
      @endif
      <button class="btn btn-primary">Proses</button>
    </form>
  </div>
</div>
@endsection
