<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('campaign_stats', function(Blueprint $t){
            $t->unsignedBigInteger('campaign_id')->primary();
            $t->integer('sent_success')->default(0);
            $t->integer('sent_failed')->default(0);
            $t->timestamps();
            $t->foreign('campaign_id')->references('id')->on('campaigns')->cascadeOnDelete();
        });
    }
    public function down(): void { Schema::dropIfExists('campaign_stats'); }
};
