<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Campaign;
use App\Models\Endpoint;
use App\Models\CampaignStat;
use App\Models\User;

class CampaignController extends Controller
{
    public function dashboard(){
        $stats = [
            'campaigns' => Campaign::where('user_id', auth()->id())->count(),
            'sent'      => optional(CampaignStat::whereIn('campaign_id', Campaign::where('user_id',auth()->id())->pluck('id'))->get())->sum('sent_success') ?? 0,
            'failed'    => optional(CampaignStat::whereIn('campaign_id', Campaign::where('user_id',auth()->id())->pluck('id'))->get())->sum('sent_failed') ?? 0,
        ];
        $list = Campaign::where('user_id', auth()->id())->orderByDesc('id')->limit(10)->get();
        return view('campaign.dashboard', compact('stats','list'));
    }

    public function index(){
        $list = Campaign::where('user_id', auth()->id())->orderByDesc('id')->paginate(20);
        return view('campaign.index', compact('list'));
    }

    public function create(){
        $endpoints = Endpoint::where('is_active',true)->orderByDesc('is_default')->get();
        return view('campaign.create', compact('endpoints'));
    }

    public function store(Request $r){
        $user = auth()->user();
        // enforce limit
        if ($user->campaign_limit && Campaign::where('user_id',$user->id)->count() >= $user->campaign_limit) {
            return back()->withErrors(['limit'=>'Limit campaign tercapai'])->withInput();
        }
        $data = $r->validate([
            'name'=>'required|string',
            'endpoint_id'=>'required|exists:endpoints,id',
            'source_type'=>'required|in:upload,sheets',
        ]);
        $c = Campaign::create([
            'user_id'=>$user->id,
            'endpoint_id'=>$data['endpoint_id'],
            'name'=>$data['name'],
            'source_type'=>$data['source_type'],
        ]);
        return redirect()->route('campaigns.upload', ['id'=>$c->id]);
    }
}
