<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function index(){
        $users = User::orderByDesc('id')->get();
        return view('admin.users', compact('users'));
    }
    public function store(Request $r){
        $data = $r->validate([
            'name'=>'required|string',
            'email'=>'required|email',
            'role'=>'required|in:admin,user',
            'status'=>'required|in:active,inactive',
            'campaign_limit'=>'nullable|integer|min:0',
            'row_limit_per_campaign'=>'nullable|integer|min:0',
            'can_custom_branding'=>'nullable|boolean',
        ]);
        $u = User::updateOrCreate(['email'=>$data['email']], [
            'name'=>$data['name'],
            'role'=>$data['role'],
            'status'=>$data['status'],
            'campaign_limit'=>$data['campaign_limit'] ?? null,
            'row_limit_per_campaign'=>$data['row_limit_per_campaign'] ?? null,
            'can_custom_branding'=>!empty($data['can_custom_branding']),
            'password'=>bcrypt('password')
        ]);
        return back()->with('ok','Saved');
    }
    public function toggle($id){
        $u = User::findOrFail($id);
        $u->status = $u->status === 'active' ? 'inactive' : 'active';
        $u->save();
        return back()->with('ok','Toggled');
    }
    public function impersonate($id){
        session(['impersonate_user_id'=>$id,'admin_backup_id'=>Auth::id()]);
        return redirect()->route('dashboard')->with('ok','Now impersonating user ID '.$id);
    }
    public function stopImpersonate(){
        session()->forget('impersonate_user_id');
        if ($adminId = session('admin_backup_id')) {
            \Auth::loginUsingId($adminId);
            session()->forget('admin_backup_id');
        }
        return redirect()->route('admin.users')->with('ok','Stopped impersonation');
    }
}
