<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CampaignController;
use App\Http\Controllers\UploadController;
use App\Http\Controllers\MappingController;
use App\Http\Controllers\PreviewController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\Admin\EndpointController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\BrandingController;

// Auth routes assumed from Laravel Breeze
// Google OAuth (optional)
Route::get('/auth/google/redirect', [SettingController::class, 'googleRedirect'])->name('google.redirect');
Route::get('/auth/google/callback', [SettingController::class, 'googleCallback'])->name('google.callback');

Route::middleware(['auth', 'web', 'impersonate'])->group(function () {
    Route::get('/', [CampaignController::class, 'dashboard'])->name('dashboard');

    // Campaigns
    Route::get('/campaigns', [CampaignController::class, 'index'])->name('campaigns.index');
    Route::get('/campaigns/create', [CampaignController::class, 'create'])->name('campaigns.create');
    Route::post('/campaigns', [CampaignController::class, 'store'])->name('campaigns.store');

    // Upload / Import
    Route::get('/campaigns/{id}/upload', [UploadController::class, 'show'])->name('campaigns.upload');
    Route::post('/campaigns/{id}/upload', [UploadController::class, 'store'])->name('campaigns.upload.store');

    // Mapping
    Route::get('/campaigns/{id}/mapping', [MappingController::class, 'show'])->name('campaigns.mapping');
    Route::post('/campaigns/{id}/mapping', [MappingController::class, 'save'])->name('campaigns.mapping.save');

    // Preview & Enqueue
    Route::get('/campaigns/{id}/preview', [PreviewController::class, 'show'])->name('campaigns.preview');
    Route::post('/campaigns/{id}/enqueue', [PreviewController::class, 'enqueue'])->name('campaigns.enqueue');

    // Reports
    Route::get('/reports', [ReportController::class, 'list'])->name('reports.list');
    Route::get('/reports/{id}', [ReportController::class, 'detail'])->name('reports.detail');
    Route::get('/reports/{id}/pdf', [ReportController::class, 'downloadPdf'])->name('reports.pdf');

    // Branding (user)
    Route::get('/branding', [BrandingController::class, 'userBranding'])->name('branding.user');
    Route::post('/branding', [BrandingController::class, 'saveUserBranding'])->name('branding.user.save');

    // Admin-only
    Route::middleware('can:admin-only')->group(function () {
        Route::get('/admin/endpoints', [EndpointController::class, 'index'])->name('admin.endpoints');
        Route::post('/admin/endpoints', [EndpointController::class, 'store'])->name('admin.endpoints.store');
        Route::post('/admin/endpoints/{id}/delete', [EndpointController::class, 'destroy'])->name('admin.endpoints.delete');

        Route::get('/admin/users', [UserController::class, 'index'])->name('admin.users');
        Route::post('/admin/users', [UserController::class, 'store'])->name('admin.users.store');
        Route::post('/admin/users/{id}/toggle', [UserController::class, 'toggle'])->name('admin.users.toggle');
        Route::post('/admin/users/{id}/impersonate', [UserController::class, 'impersonate'])->name('admin.users.impersonate');
        Route::post('/admin/stop-impersonate', [UserController::class, 'stopImpersonate'])->name('admin.users.stopimpersonate');

        Route::get('/admin/settings', [SettingController::class, 'index'])->name('admin.settings');
        Route::post('/admin/settings', [SettingController::class, 'save'])->name('admin.settings.save');

        Route::get('/admin/branding', [BrandingController::class, 'adminBranding'])->name('admin.branding');
        Route::post('/admin/branding', [BrandingController::class, 'saveAdminBranding'])->name('admin.branding.save');
    });
});
