<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <style>
    body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
    .brand { color: #25D366; }
    .header { border-bottom: 2px solid #25D366; margin-bottom: 10px; padding-bottom: 6px; }
    table { width: 100%; border-collapse: collapse; margin-top: 10px; }
    th, td { border: 1px solid #ddd; padding: 6px; }
    th { background: #25D366; color: #fff; }
    .footer { text-align: center; margin-top: 18px; color: #25D366; font-size: 11px; }
  </style>
</head>
<body>
  <div class="header">
    @if ($logoPath && file_exists($logoPath))
      <img src="{{ $logoPath }}" style="height:40px">
    @endif
    <h3 class="brand">Laporan Campaign – {{ $meta['campaign_name'] ?? '-' }}</h3>
  </div>

  <table>
    <tr><th>Template ID</th><td>{{ $meta['template_id'] ?? '-' }}</td></tr>
    <tr><th>Tanggal</th><td>{{ $meta['created_at'] ?? '-' }}</td></tr>
    <tr><th>Total</th><td>{{ $summary['total'] ?? 0 }}</td></tr>
    <tr><th>Terkirim</th><td>{{ $summary['success'] ?? 0 }}</td></tr>
    <tr><th>Gagal</th><td>{{ $summary['failed'] ?? 0 }}</td></tr>
  </table>

  <h4 class="brand">Detail (maks 500 baris)</h4>
  <table>
    <thead><tr><th>ID</th><th>Status</th><th>Code</th><th>Payload</th><th>Response</th><th>Waktu</th></tr></thead>
    <tbody>
      @foreach ($details as $d)
        <tr>
          <td>{{ $d['id'] }}</td>
          <td>{{ $d['status'] }}</td>
          <td>{{ $d['response_code'] }}</td>
          <td><pre style="white-space:pre-wrap">{{ $d['payload_json'] }}</pre></td>
          <td><pre style="white-space:pre-wrap">{{ $d['response_body'] }}</pre></td>
          <td>{{ $d['created_at'] }}</td>
        </tr>
      @endforeach
    </tbody>
  </table>

  <div class="footer">Powered by {{ $footerText }}</div>
</body>
</html>
