@extends('layouts.app')
@section('title','Laporan Campaign')
@section('content')
<div class="card">
  <div class="card-body">
    <table class="table">
      <thead><tr><th>Nama</th><th>Template</th><th>Total</th><th>Terkirim</th><th>Gagal</th><th>Status</th><th>Aksi</th></tr></thead>
      <tbody>
        @foreach ($list as $c)
          @php $s = $stats[$c->id] ?? null; @endphp
          <tr>
            <td>{{ $c->name }}</td>
            <td>{{ $c->template_id ?? '-' }}</td>
            <td>{{ $c->total_rows }}</td>
            <td>{{ $s->sent_success ?? 0 }}</td>
            <td>{{ $s->sent_failed ?? 0 }}</td>
            <td>{{ $c->status }}</td>
            <td><a href="{{ route('reports.detail',$c->id) }}" class="btn btn-sm btn-primary">Detail</a></td>
          </tr>
        @endforeach
      </tbody>
    </table>
    {{ $list->links() }}
  </div>
</div>
@endsection
