@extends('layouts.app')
@section('title','Mapping Kolom')
@section('content')
<div class="card">
  <div class="card-body">
    <form method="post" action="{{ route('campaigns.mapping.save',$campaign->id) }}">
      @csrf
      <div class="row">
        <div class="col-md-6">
          <h5 class="text-brand">Field Wajib</h5>
          @php $fields=['apiToken'=>'API Token','phone_number_id'=>'Phone Number ID','template_id'=>'Template ID','phone_number'=>'Phone Number']; @endphp
          @foreach ($fields as $key=>$label)
            @php $m = $mappings[$key] ?? null; @endphp
            <div class="border rounded p-3 mb-3">
              <b>{{ $label }}</b>
              <div class="form-row mt-2">
                <div class="col">
                  <label>Pilih Kolom</label>
                  <select class="form-control" name="map_col_{{ $key }}">
                    <option value="">(Static Value)</option>
                    @foreach ($headers as $h)
                      <option value="{{ $h }}" @if ($m && $m->column_name===$h) selected @endif>{{ $h }}</option>
                    @endforeach
                  </select>
                </div>
                <div class="col">
                  <label>Static Value</label>
                  <input type="text" class="form-control" name="static_{{ $key }}" value="{{ $m->static_value ?? '' }}">
                </div>
              </div>
            </div>
          @endforeach
        </div>
        <div class="col-md-6">
          <h5 class="text-brand">Custom templateVariable</h5>
          <table class="table">
            <thead><tr><th>Nama Field</th><th>Urutan</th><th>Kolom</th><th>Static</th></tr></thead>
            <tbody id="custom-rows">
              <tr>
                <td><input class="form-control" name="custom_name[]"></td>
                <td><input class="form-control" name="custom_order[]" type="number"></td>
                <td>
                  <select class="form-control" name="custom_col[]">
                    <option value="">(Static)</option>
                    @foreach ($headers as $h)
                      <option value="{{ $h }}">{{ $h }}</option>
                    @endforeach
                  </select>
                </td>
                <td><input class="form-control" name="custom_static[]"></td>
              </tr>
            </tbody>
          </table>
          <button type="button" class="btn btn-outline-secondary" onclick="addRow()">+ Tambah Field</button>
        </div>
      </div>
      <div class="text-right">
        <button class="btn btn-success">Simpan & Lanjut Preview</button>
      </div>
    </form>
    <hr>
    <h6>Preview 5 baris pertama</h6>
    <div class="table-responsive">
      <table class="table table-striped">
        <thead><tr>@foreach ($headers as $h)<th>{{ $h }}</th>@endforeach</tr></thead>
        <tbody>@foreach ($rowsPreview as $r)<tr>@foreach ($headers as $h)<td>{{ $r[$h] ?? '' }}</td>@endforeach</tr>@endforeach</tbody>
      </table>
    </div>
  </div>
</div>
<script>
function addRow(){
  const tpl = document.querySelector('#custom-rows tr').outerHTML;
  document.querySelector('#custom-rows').insertAdjacentHTML('beforeend', tpl);
}
</script>
@endsection
