@extends('layouts.app')
@section('title','Buat Campaign')
@section('content')
<div class="card">
  <div class="card-body">
    <form method="post" action="{{ route('campaigns.store') }}">
      @csrf
      <div class="form-group">
        <label>Nama Campaign</label>
        <input type="text" name="name" class="form-control" required>
      </div>
      <div class="form-group">
        <label>Pilih Endpoint</label>
        <select name="endpoint_id" class="form-control" required>
          @foreach ($endpoints as $e)
            <option value="{{ $e->id }}">{{ $e->label }} ({{ $e->method }})</option>
          @endforeach
        </select>
      </div>
      <div class="form-group">
        <label>Sumber Data</label>
        <select name="source_type" class="form-control">
          <option value="upload">Upload CSV</option>
          <option value="sheets">Google Sheets</option>
        </select>
      </div>
      <button class="btn btn-primary">Lanjut Upload</button>
    </form>
  </div>
</div>
@endsection
