@extends('layouts.app')
@section('title','Admin - Users')
@section('content')
<div class="card">
  <div class="card-body">
    <form method="post" action="{{ route('admin.users.store') }}">
      @csrf
      <div class="form-row">
        <div class="col"><input name="name" class="form-control" placeholder="Nama" required></div>
        <div class="col"><input name="email" type="email" class="form-control" placeholder="Email" required></div>
        <div class="col">
          <select name="role" class="form-control">
            <option value="user">User</option>
            <option value="admin">Admin</option>
          </select>
        </div>
        <div class="col">
          <select name="status" class="form-control">
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
          </select>
        </div>
      </div>
      <div class="form-row mt-2">
        <div class="col"><input name="campaign_limit" type="number" class="form-control" placeholder="Campaign Limit (opsional)"></div>
        <div class="col"><input name="row_limit_per_campaign" type="number" class="form-control" placeholder="Row Limit per Campaign (opsional)"></div>
        <div class="col">
          <div class="form-check mt-2">
            <input type="checkbox" class="form-check-input" id="cbrand" name="can_custom_branding">
            <label class="form-check-label" for="cbrand">Custom Branding</label>
          </div>
        </div>
        <div class="col"><button class="btn btn-primary">Simpan</button></div>
      </div>
    </form>
    <hr>
    <table class="table">
      <thead><tr><th>Nama</th><th>Email</th><th>Role</th><th>Status</th><th>Limit</th><th>Branding</th><th>Aksi</th></tr></thead>
      <tbody>
        @foreach ($users as $u)
        <tr>
          <td>{{ $u->name }}</td>
          <td>{{ $u->email }}</td>
          <td>{{ $u->role }}</td>
          <td>{{ $u->status }}</td>
          <td>{{ $u->campaign_limit ?? '-' }}/{{ $u->row_limit_per_campaign ?? '-' }}</td>
          <td>{{ $u->can_custom_branding ? 'Yes' : 'No' }}</td>
          <td class="d-flex">
            <form method="post" action="{{ route('admin.users.toggle',$u->id) }}" class="mr-2">@csrf<button class="btn btn-sm btn-warning">Aktif/Nonaktif</button></form>
            <form method="post" action="{{ route('admin.users.impersonate',$u->id) }}">@csrf<button class="btn btn-sm btn-info">Login as</button></form>
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
