@extends('layouts.app')
@section('title','Admin - Settings')
@section('content')
<div class="card">
  <div class="card-header"><h4>System Settings</h4></div>
  <div class="card-body">
    <form method="post" action="{{ route('admin.settings.save') }}">@csrf
      <div class="form-row">
        <div class="col-md-6">
          <div class="form-group"><label>Footer Text</label><input class="form-control" name="footer_text" value="{{ $settings['footer_text'] }}"></div>
          <div class="form-group"><label>Log Retention (days)</label><input class="form-control" type="number" name="log_retention_days" value="{{ $settings['log_retention_days'] }}"></div>
        </div>
        <div class="col-md-6">
          <div class="form-group"><label>Worker Batch Size</label><input class="form-control" type="number" name="worker_batch_size" value="{{ $settings['worker_batch_size'] }}"></div>
          <div class="form-group"><label>Sleep Between (sec)</label><input class="form-control" type="number" name="worker_sleep_between" value="{{ $settings['worker_sleep_between'] }}"></div>
          <div class="form-group"><label>Max Attempts</label><input class="form-control" type="number" name="worker_max_attempts" value="{{ $settings['worker_max_attempts'] }}"></div>
        </div>
      </div>
      <hr>
      <h5 class="text-brand">Google OAuth</h5>
      <div class="form-row">
        <div class="col-md-4"><label>Client ID</label><input class="form-control" name="google_client_id" value="{{ $settings['google_client_id'] }}"></div>
        <div class="col-md-4"><label>Client Secret</label><input class="form-control" name="google_client_secret" value="{{ $settings['google_client_secret'] }}"></div>
        <div class="col-md-4"><label>Redirect URI</label><input class="form-control" name="google_redirect_uri" value="{{ $settings['google_redirect_uri'] }}" readonly></div>
      </div>
      <div class="text-right mt-3"><button class="btn btn-success">Simpan</button></div>
    </form>
  </div>
</div>
@endsection
