@extends('layouts.app')
@section('title','Admin - Endpoints')
@section('content')
<div class="card">
  <div class="card-body">
    <form method="post" action="{{ route('admin.endpoints.store') }}">
      @csrf
      <div class="form-row">
        <div class="col"><input name="label" class="form-control" placeholder="Label" required></div>
        <div class="col">
          <select name="method" class="form-control"><option>POST</option><option>GET</option></select>
        </div>
        <div class="col"><input name="url" class="form-control" placeholder="https://.../send/template" required></div>
        <div class="col"><div class="form-check"><input class="form-check-input" type="checkbox" name="is_default" id="def"><label class="form-check-label" for="def">Default</label></div></div>
        <div class="col"><div class="form-check"><input class="form-check-input" type="checkbox" name="is_active" id="act" checked><label class="form-check-label" for="act">Active</label></div></div>
        <div class="col"><button class="btn btn-primary">Tambah</button></div>
      </div>
    </form>
    <hr>
    <table class="table">
      <thead><tr><th>Label</th><th>Method</th><th>URL</th><th>Default</th><th>Active</th><th></th></tr></thead>
      <tbody>
        @foreach ($list as $e)
        <tr>
          <td>{{ $e->label }}</td>
          <td>{{ $e->method }}</td>
          <td>{{ $e->url }}</td>
          <td>{{ $e->is_default ? 'Yes' : 'No' }}</td>
          <td>{{ $e->is_active ? 'Yes' : 'No' }}</td>
          <td>
            <form method="post" action="{{ route('admin.endpoints.delete',$e->id) }}">@csrf<button class="btn btn-sm btn-danger">Hapus</button></form>
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
