<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('users', function(Blueprint $t){
            $t->enum('role',['admin','user'])->default('user')->after('password');
            $t->enum('status',['active','inactive'])->default('active')->after('role');
            $t->integer('campaign_limit')->nullable()->after('status');
            $t->integer('row_limit_per_campaign')->nullable()->after('campaign_limit');
            $t->boolean('can_custom_branding')->default(false)->after('row_limit_per_campaign');
        });
    }
    public function down(): void {
        Schema::table('users', function(Blueprint $t){
            $t->dropColumn(['role','status','campaign_limit','row_limit_per_campaign','can_custom_branding']);
        });
    }
};
