<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('queue_items', function(Blueprint $t){
            $t->id();
            $t->foreignId('campaign_id')->constrained('campaigns')->cascadeOnDelete();
            $t->integer('row_index');
            $t->json('payload_json');
            $t->enum('status',['pending','processing','success','failed'])->default('pending');
            $t->integer('response_code')->nullable();
            $t->longText('response_body')->nullable();
            $t->longText('last_error')->nullable();
            $t->integer('attempts')->default(0);
            $t->timestamps();
            $t->index(['campaign_id','status']);
        });
    }
    public function down(): void { Schema::dropIfExists('queue_items'); }
};
