<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('campaign_mappings', function(Blueprint $t){
            $t->id();
            $t->foreignId('campaign_id')->constrained('campaigns')->cascadeOnDelete();
            $t->string('field_key'); // apiToken, phone_number_id, template_id, phone_number, templateVariable-xxx-1
            $t->string('column_name')->nullable();
            $t->text('static_value')->nullable();
            $t->timestamps();
            $t->unique(['campaign_id','field_key']);
        });
    }
    public function down(): void { Schema::dropIfExists('campaign_mappings'); }
};
