<?php
namespace App\Services;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class SheetsFetcher
{
    public static function toCsvUrl(string $sheetUrl): ?string {
        if (!preg_match('#/d/([^/]+)/#', $sheetUrl, $m)) return null;
        $sid = $m[1];
        $gid = 0;
        if (preg_match('/gid=(\d+)/', $sheetUrl, $g)) $gid = $g[1];
        return "https://docs.google.com/spreadsheets/d/{$sid}/export?format=csv&gid={$gid}";
    }

    public static function fetchTo(string $csvUrl, string $destPath): bool {
        try {
            $data = file_get_contents($csvUrl);
            if ($data === false) return false;
            file_put_contents($destPath, $data);
            return true;
        } catch (\Throwable $e) {
            return false;
        }
    }

    public static function csvPreview(string $path, int $limit = 5): array {
        $rows = [];
        if (!is_readable($path)) return [[],[]];
        if (($h = fopen($path, 'r')) !== false) {
            $header = fgetcsv($h);
            if (!$header) { fclose($h); return [[],[]]; }
            $i = 0;
            while (($data = fgetcsv($h)) !== false) {
                $rows[] = array_combine($header, $data);
                $i++; if ($i >= $limit) break;
            }
            fclose($h);
            return [$header, $rows];
        }
        return [[],[]];
    }

    public static function csvAll(string $path): array {
        $rows = [];
        if (!is_readable($path)) return [];
        if (($h = fopen($path, 'r')) !== false) {
            $header = fgetcsv($h);
            if (!$header) { fclose($h); return []; }
            while (($data = fgetcsv($h)) !== false) {
                $rows[] = array_combine($header, $data);
            }
            fclose($h);
            return $rows;
        }
        return [];
    }
}
