<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class Impersonate
{
    public function handle(Request $request, Closure $next): Response
    {
        if (session()->has('impersonate_user_id')) {
            $impersonateId = session('impersonate_user_id');
            if ($impersonateId && (!Auth::check() || Auth::id() != $impersonateId)) {
                Auth::loginUsingId($impersonateId);
            }
        }
        return $next($request);
    }
}
