<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Campaign;
use App\Services\SheetsFetcher;

class UploadController extends Controller
{
    public function show($id){
        $campaign = Campaign::where('id',$id)->where('user_id',auth()->id())->firstOrFail();
        return view('campaign.upload', compact('campaign'));
    }

    public function store(Request $r, $id){
        $campaign = Campaign::where('id',$id)->where('user_id',auth()->id())->firstOrFail();
        if ($campaign->source_type === 'upload') {
            $r->validate(['file'=>'required|file']);
            $path = $r->file('file')->store('public/uploads');
            $campaign->file_path = storage_path('app/'.$path);
            // count rows
            [$h, $rows] = SheetsFetcher::csvPreview($campaign->file_path, 1000000);
            $campaign->total_rows = count($rows);
            $campaign->save();
        } else {
            $data = $r->validate(['sheets_url'=>'required|url']);
            $csvUrl = SheetsFetcher::toCsvUrl($data['sheets_url']);
            abort_unless($csvUrl, 422, 'URL Google Sheet tidak valid');
            $dest = storage_path('app/public/uploads/campaign_'.$campaign->id.'.csv');
            if (!is_dir(dirname($dest))) mkdir(dirname($dest), 0775, true);
            $ok = SheetsFetcher::fetchTo($csvUrl, $dest);
            abort_unless($ok, 500, 'Gagal fetch Sheet');
            $campaign->sheets_url = $data['sheets_url'];
            $campaign->file_path = $dest;
            [$h, $rows] = SheetsFetcher::csvPreview($campaign->file_path, 1000000);
            $campaign->total_rows = count($rows);
            $campaign->save();
        }

        // enforce row limit
        $limit = auth()->user()->row_limit_per_campaign;
        if ($limit && $campaign->total_rows > $limit) {
            return back()->withErrors(['limit'=>"Maksimal {$limit} baris per campaign"])->withInput();
        }
        return redirect()->route('campaigns.mapping', ['id'=>$campaign->id]);
    }
}
