<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Campaign;
use App\Models\QueueItem;
use App\Models\CampaignStat;
use App\Models\Branding;
use App\Models\Setting;
use App\Services\PdfReportService;

class ReportController extends Controller
{
    public function list(){
        $list = Campaign::where('user_id', auth()->id())->orderByDesc('id')->paginate(20);
        $stats = CampaignStat::whereIn('campaign_id', $list->pluck('id'))->get()->keyBy('campaign_id');
        return view('report.list', compact('list','stats'));
    }

    public function detail($id){
        $campaign = Campaign::where('id',$id)->where('user_id',auth()->id())->firstOrFail();
        $items = QueueItem::where('campaign_id',$id)->orderBy('id','asc')->paginate(100);
        $stat = CampaignStat::where('campaign_id',$id)->first();
        return view('report.detail', compact('campaign','items','stat'));
    }

    public function downloadPdf($id){
        $campaign = Campaign::where('id',$id)->where('user_id',auth()->id())->firstOrFail();

        // Check retention: if there are no more detail logs, deny download.
        $hasAny = QueueItem::where('campaign_id',$id)->exists();
        if (!$hasAny) return back()->withErrors(['log'=>'Log detail sudah dihapus (melebihi retention).']);

        $details = QueueItem::where('campaign_id',$id)->orderBy('id','asc')->limit(500)->get(['id','response_code','status','payload_json','created_at']);
        $stat = CampaignStat::where('campaign_id',$id)->first();
        $meta = [
            'campaign_name'=>$campaign->name,
            'template_id'=>$campaign->template_id,
            'created_at'=>$campaign->created_at?->format('d-m-Y'),
        ];
        $summary = [
            'total'=>$campaign->total_rows,
            'success'=>$stat->sent_success ?? 0,
            'failed' =>$stat->sent_failed ?? 0,
        ];

        // Branding
        $userBrand = null;
        if (auth()->user()->can_custom_branding) {
            $userBrand = Branding::where('user_id',auth()->id())->where('type','user')->first();
        }
        $adminBrand = Branding::where('type','admin')->first();
        $logoPath = $userBrand?->logo_path ? storage_path('app/'. $userBrand->logo_path) : ($adminBrand?->logo_path ? storage_path('app/'.$adminBrand->logo_path) : null);
        $footerText = $userBrand?->brand_text ?: ($adminBrand?->brand_text ?: Setting::get('footer_text','Meiwa Cloud API'));

        $filePath = PdfReportService::generate($meta, $summary, $details->toArray(), $logoPath, $footerText);
        return response()->download($filePath)->deleteFileAfterSend(true);
    }
}
