<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Campaign;
use App\Models\CampaignMapping;
use App\Models\QueueItem;
use App\Services\SheetsFetcher;

class PreviewController extends Controller
{
    protected function buildPayload(array $row, $mapping): array {
        $payload = [];
        foreach ($mapping as $key => $m) {
            $val = $m['static_value'] ?? null;
            if (!$val && !empty($m['column_name']) && isset($row[$m['column_name']])) {
                $val = $row[$m['column_name']];
            }
            if ($val !== null) $payload[$key] = $val;
        }
        return $payload;
    }

    public function show($id){
        $campaign = Campaign::where('id',$id)->where('user_id',auth()->id())->firstOrFail();
        [$headers, $rows] = SheetsFetcher::csvPreview($campaign->file_path, 3);
        $maps = CampaignMapping::where('campaign_id',$id)->get()->keyBy('field_key')->toArray();
        $previews = [];
        foreach ($rows as $r) $previews[] = $this->buildPayload($r, $maps);
        return view('campaign.preview', compact('campaign','previews'));
    }

    public function enqueue(Request $r, $id){
        $campaign = Campaign::where('id',$id)->where('user_id',auth()->id())->firstOrFail();
        $allRows = SheetsFetcher::csvAll($campaign->file_path);
        $maps = CampaignMapping::where('campaign_id',$id)->get()->keyBy('field_key')->toArray();
        $i = 0;
        foreach ($allRows as $row) {
            $payload = $this->buildPayload($row, $maps);
            QueueItem::create([
                'campaign_id'=>$id,
                'row_index'=>$i++,
                'payload_json'=>json_encode($payload, JSON_UNESCAPED_UNICODE)
            ]);
        }
        $campaign->status='queued'; $campaign->save();
        return redirect()->route('reports.detail', ['id'=>$id])->with('ok','Campaign dienqueue');
    }
}
