<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Campaign;
use App\Models\CampaignMapping;
use App\Services\SheetsFetcher;

class MappingController extends Controller
{
    public function show($id){
        $campaign = Campaign::where('id',$id)->where('user_id',auth()->id())->firstOrFail();
        [$headers, $rowsPreview] = SheetsFetcher::csvPreview($campaign->file_path, 5);
        $mappings = CampaignMapping::where('campaign_id',$id)->get()->keyBy('field_key');
        return view('campaign.mapping', compact('campaign','headers','rowsPreview','mappings'));
    }

    public function save(Request $r, $id){
        $campaign = Campaign::where('id',$id)->where('user_id',auth()->id())->firstOrFail();

        // required fields
        $keys = ['apiToken','phone_number_id','template_id','phone_number'];
        foreach ($keys as $k) {
            $col = $r->input("map_col_$k");
            $static = $r->input("static_$k");
            CampaignMapping::updateOrCreate(
                ['campaign_id'=>$id,'field_key'=>$k],
                ['column_name'=>$col ?: null, 'static_value'=>$static ?: null]
            );
        }
        // custom
        $names = $r->input('custom_name',[]);
        $orders= $r->input('custom_order',[]);
        $cols  = $r->input('custom_col',[]);
        $stt   = $r->input('custom_static',[]);
        for ($i=0; $i<count($names); $i++){
            if (!$names[$i] || !$orders[$i]) continue;
            $key = "templateVariable-".preg_replace('/[^a-zA-Z0-9_\-]/','',$names[$i])."-".intval($orders[$i]);
            CampaignMapping::updateOrCreate(
                ['campaign_id'=>$id,'field_key'=>$key],
                ['column_name'=>$cols[$i] ?: null, 'static_value'=>$stt[$i] ?: null]
            );
        }
        return redirect()->route('campaigns.preview', ['id'=>$id]);
    }
}
