<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class SettingController extends Controller
{
    public function index(){
        $settings = [
            'footer_text'=> Setting::get('footer_text','Meiwa Cloud API'),
            'log_retention_days'=> Setting::get('log_retention_days', 10),
            'worker_batch_size'=> Setting::get('worker_batch_size', 20),
            'worker_sleep_between'=> Setting::get('worker_sleep_between', 1),
            'worker_max_attempts'=> Setting::get('worker_max_attempts', 3),
            'google_client_id'=> Setting::get('google_client_id',''),
            'google_client_secret'=> Setting::get('google_client_secret',''),
            'google_redirect_uri'=> Setting::get('google_redirect_uri', config('app.url').'/auth/google/callback'),
        ];
        return view('admin.settings', compact('settings'));
    }
    public function save(Request $r){
        $data = $r->validate([
            'footer_text'=>'nullable|string',
            'log_retention_days'=>'required|integer|min:1|max:60',
            'worker_batch_size'=>'required|integer|min:1|max:500',
            'worker_sleep_between'=>'required|integer|min:0|max:10',
            'worker_max_attempts'=>'required|integer|min:1|max:10',
            'google_client_id'=>'nullable|string',
            'google_client_secret'=>'nullable|string',
            'google_redirect_uri'=>'nullable|string',
        ]);
        foreach ($data as $k=>$v) { Setting::set($k, $v); }
        return back()->with('ok','Saved');
    }

    // Google OAuth (public routes defined in web.php)
    public function googleRedirect(){
        if (!Setting::get('google_client_id') || !Setting::get('google_client_secret')) abort(404);
        config(['services.google.client_id'=>Setting::get('google_client_id')]);
        config(['services.google.client_secret'=>Setting::get('google_client_secret')]);
        config(['services.google.redirect'=>Setting::get('google_redirect_uri', config('app.url').'/auth/google/callback')]);
        return Socialite::driver('google')->redirect();
    }

    public function googleCallback(){
        config(['services.google.client_id'=>Setting::get('google_client_id')]);
        config(['services.google.client_secret'=>Setting::get('google_client_secret')]);
        config(['services.google.redirect'=>Setting::get('google_redirect_uri', config('app.url').'/auth/google/callback')]);
        $googleUser = Socialite::driver('google')->stateless()->user();
        $user = User::updateOrCreate(['email'=>$googleUser->getEmail()], [
            'name'=>$googleUser->getName() ?: $googleUser->getNickname(),
            'password'=>bcrypt(str()->random(12)),
            'status'=>'active'
        ]);
        \Auth::login($user, true);
        return redirect()->route('dashboard');
    }
}
