<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Endpoint;

class EndpointController extends Controller
{
    public function index(){
        $list = Endpoint::orderByDesc('is_default')->orderByDesc('id')->get();
        return view('admin.endpoints', compact('list'));
    }
    public function store(Request $r){
        $data = $r->validate([
            'label'=>'required|string',
            'method'=>'required|in:GET,POST',
            'url'=>'required|string',
            'is_default'=>'nullable|boolean',
            'is_active'=>'nullable|boolean',
        ]);
        if (!empty($data['is_default'])) {
            Endpoint::query()->update(['is_default'=>false]);
        }
        Endpoint::create([
            'label'=>$data['label'],
            'method'=>$data['method'],
            'url'=>$data['url'],
            'is_default'=>!empty($data['is_default']),
            'is_active'=>!empty($data['is_active']),
        ]);
        return back()->with('ok','Saved');
    }
    public function destroy($id){
        Endpoint::where('id',$id)->delete();
        return back()->with('ok','Deleted');
    }
}
