<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Branding;
use App\Models\Setting;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class BrandingController extends Controller
{
    public function adminBranding(){
        $branding = Branding::where('type','admin')->first();
        return view('admin.branding', compact('branding'));
    }
    public function saveAdminBranding(Request $r){
        $data = $r->validate([
            'brand_text'=>'nullable|string',
            'logo'=>'nullable|image|max:2048'
        ]);
        $branding = Branding::firstOrCreate(['user_id'=>auth()->id(),'type'=>'admin']);
        if ($r->hasFile('logo')){
            $path = $r->file('logo')->store('public/branding');
            $branding->logo_path = $path;
        }
        $branding->brand_text = $data['brand_text'] ?? $branding->brand_text;
        $branding->save();
        return back()->with('ok','Saved');
    }

    // user side
    public function userBranding(){
        abort_unless(auth()->user()->can_custom_branding, 403);
        $branding = Branding::firstOrCreate(['user_id'=>auth()->id(),'type'=>'user']);
        return view('branding.user', compact('branding'));
    }
    public function saveUserBranding(Request $r){
        abort_unless(auth()->user()->can_custom_branding, 403);
        $data = $r->validate([
            'brand_text'=>'nullable|string',
            'logo'=>'nullable|image|max:2048'
        ]);
        $branding = Branding::firstOrCreate(['user_id'=>auth()->id(),'type'=>'user']);
        if ($r->hasFile('logo')){
            $path = $r->file('logo')->store('public/branding');
            $branding->logo_path = $path;
        }
        $branding->brand_text = $data['brand_text'] ?? $branding->brand_text;
        $branding->save();
        return back()->with('ok','Saved');
    }
}
