<?php
// Put this file into app/Providers/AuthServiceProvider.php in your Laravel app and register in config/app.php if needed.
namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [ /* ... */ ];

    public function boot(): void
    {
        $this->registerPolicies();

        Gate::define('admin-only', function ($user) {
            return $user && $user->role === 'admin';
        });
    }
}
