@extends('layouts.app')
@section('title','Detail Campaign')
@section('content')
<div class="card">
  <div class="card-body">
    <div class="row">
      <div class="col-md-6">
        <ul class="list-unstyled">
          <li><b>Nama:</b> {{ $campaign->name }}</li>
          <li><b>Template ID:</b> {{ $campaign->template_id ?? '-' }}</li>
          <li><b>Total:</b> {{ $campaign->total_rows }}</li>
          <li><b>Status:</b> {{ $campaign->status }}</li>
        </ul>
      </div>
      <div class="col-md-6 text-right">
        <a href="{{ route('reports.pdf',$campaign->id) }}" class="btn btn-success">Download PDF</a>
      </div>
    </div>
    <hr>
    <div class="table-responsive">
      <table class="table table-striped">
        <thead><tr><th>#</th><th>Status</th><th>Code</th><th>Payload</th><th>Response</th><th>Waktu</th></tr></thead>
        <tbody>
          @foreach ($items as $it)
          <tr>
            <td>{{ $it->id }}</td>
            <td>
              @if ($it->status==='success') <span class="badge badge-success">Terkirim</span>
              @elseif ($it->status==='failed') <span class="badge badge-danger">Gagal</span>
              @else <span class="badge badge-warning">{{ $it->status }}</span>
              @endif
            </td>
            <td>{{ $it->response_code }}</td>
            <td><code style="white-space:pre-wrap">{{ $it->payload_json }}</code></td>
            <td><code style="white-space:pre-wrap">{{ Str::limit($it->response_body, 200) }}</code></td>
            <td>{{ $it->created_at }}</td>
          </tr>
          @endforeach
        </tbody>
      </table>
      {{ $items->links() }}
    </div>
  </div>
</div>
@endsection
