@extends('layouts.app')
@section('title','Campaign')
@section('content')
<div class="card">
  <div class="card-header"><h4>Daftar Campaign</h4><div class="card-header-action"><a href="{{ route('campaigns.create') }}" class="btn btn-primary">Buat Campaign</a></div></div>
  <div class="card-body">
    <table class="table">
      <thead><tr><th>Nama</th><th>Endpoint</th><th>Status</th><th>Total</th><th>Dibuat</th><th>Aksi</th></tr></thead>
      <tbody>
        @foreach ($list as $c)
        <tr>
          <td>{{ $c->name }}</td>
          <td>{{ $c->endpoint->label ?? '-' }}</td>
          <td>{{ $c->status }}</td>
          <td>{{ $c->total_rows }}</td>
          <td>{{ $c->created_at }}</td>
          <td>
            <a href="{{ route('campaigns.upload',$c->id) }}" class="btn btn-sm btn-secondary">Upload</a>
            <a href="{{ route('campaigns.mapping',$c->id) }}" class="btn btn-sm btn-info">Mapping</a>
            <a href="{{ route('campaigns.preview',$c->id) }}" class="btn btn-sm btn-success">Preview</a>
            <a href="{{ route('reports.detail',$c->id) }}" class="btn btn-sm btn-primary">Laporan</a>
          </td>
        </tr>
        @endforeach
      </tbody>
    </table>
    {{ $list->links() }}
  </div>
</div>
@endsection
