<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('campaigns', function(Blueprint $t){
            $t->id();
            $t->foreignId('user_id')->constrained('users');
            $t->foreignId('endpoint_id')->constrained('endpoints');
            $t->string('name');
            $t->enum('source_type',['upload','sheets'])->default('upload');
            $t->string('file_path')->nullable();
            $t->string('sheets_url')->nullable();
            $t->string('template_id')->nullable();
            $t->enum('status',['draft','queued','sending','done','error'])->default('draft');
            $t->integer('total_rows')->default(0);
            $t->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('campaigns'); }
};
