<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('endpoints', function(Blueprint $t){
            $t->id();
            $t->string('label');
            $t->enum('method',['GET','POST'])->default('POST');
            $t->string('url', 500);
            $t->boolean('is_default')->default(false);
            $t->boolean('is_active')->default(true);
            $t->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('endpoints'); }
};
