<?php
namespace App\Services;

use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

class PdfReportService
{
    public static function generate(array $meta, array $summary, array $details, ?string $logoPath, ?string $footerText): string
    {
        $html = view('report.pdf', compact('meta','summary','details','logoPath','footerText'))->render();
        $pdf = Pdf::loadHTML($html)->setPaper('a4', 'portrait');
        $filename = 'report_'.($meta['campaign_name'] ?? 'campaign').'_'.date('Ymd_His').'.pdf';
        $outputPath = storage_path('app/public/'.$filename);
        $pdf->save($outputPath);
        return $outputPath;
    }
}
