# Meiwa WhatsApp Campaign (Laravel Module Starter)

This ZIP is a **drop-in module** for a fresh Laravel project. You'll install Laravel first, then copy these files over the Laravel root, run composer requirements, migrate, seed, and set the cron.

## 1) Create fresh Laravel
```bash
composer create-project laravel/laravel meiwa-app
cd meiwa-app
```

## 2) Copy module files
Extract this ZIP and copy/merge all folders into your Laravel root (overwrite if asked).

## 3) Composer requires
```bash
composer require laravel/socialite:^5.14 barryvdh/laravel-dompdf:^2.0 guzzlehttp/guzzle:^7.0
```

## 4) Auth scaffolding (recommended)
Use Breeze for login/register quickly:
```bash
composer require laravel/breeze --dev
php artisan breeze:install blade
npm install && npm run build  # or skip if you don't need assets
php artisan migrate
```
(If you don't want Breeze now, ensure you have **Auth** middleware and a logged-in user to access routes.)

## 5) ENV setup
Edit `.env`:
```
APP_URL=https://your-domain.com
SESSION_DRIVER=file
QUEUE_CONNECTION=sync

# Optional Google OAuth (leave empty to disable)
GOOGLE_CLIENT_ID=
GOOGLE_CLIENT_SECRET=
GOOGLE_REDIRECT_URI=${APP_URL}/auth/google/callback
```

## 6) Migrate database
```bash
php artisan migrate
```

## 7) Seed an admin (optional quick start)
```bash
php artisan tinker
>>> \App\Models\User::create(['name'=>'Admin','email'=>'admin@meiwa.cloud','password'=>bcrypt('password'),'role'=>'admin','status'=>'active']);
```

## 8) Set Scheduler/Cron
**Server cron** (every minute):
```
* * * * * php /path/to/laravel/artisan schedule:run >> /dev/null 2>&1
```

## 9) Login & Configure
- Login as admin → go to **Admin > Endpoints**: add `POST https://app.meiwa.cloud/api/v1/whatsapp/send/template` and set default.
- Admin > Settings:
  - Footer text (default: Meiwa Cloud API)
  - Google OAuth settings (if used)
  - Log retention days (default 10)
  - Rate-limit (sleep seconds) & batch size
- Admin > Users: create/activate users, set limits, enable **Custom Branding Report** if needed.
- User: create campaign → upload CSV or import Sheets URL → mapping → preview → enqueue → report → download PDF (if logs ≤ retention days).

## Notes
- This module stores logs per-row and auto-cleans logs older than retention days.
- For Google Sheets import, set sheet to **Anyone with the link (Viewer)**. The system converts Sheet URL to CSV export internally.
- PDF uses DomPDF; branding uses uploaded logos and footer text.
