<?php
/**
 * Meiwa Cloud – cPanel Laravel Installer
 * Usage: upload this file to your Laravel root, open in browser: https://domain.com/installer.php
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

function out($msg){ echo "<pre>".htmlspecialchars($msg)."</pre>"; @ob_flush(); @flush(); }

$steps = isset($_GET['step']) ? $_GET['step'] : '';

if ($steps === '') {
  ?>
  <h2>Meiwa Cloud – cPanel Laravel Installer</h2>
  <ol>
    <li>Upload <b>project Laravel</b> (beserta file ZIP modul Meiwa) ke folder tujuan.</li>
    <li>Edit <code>.env</code> (DB, APP_URL).</li>
    <li>Klik tombol di bawah ini berurutan.</li>
  </ol>
  <p><a href="?step=permissions">1) Set Folder Permission</a></p>
  <p><a href="?step=composer">2) Install Composer Dependencies</a></p>
  <p><a href="?step=key">3) Generate APP_KEY</a></p>
  <p><a href="?step=migrate">4) Run Migration</a></p>
  <p><a href="?step=done">Selesai</a></p>
  <?php
  exit;
}

if ($steps === 'permissions') {
  @mkdir(__DIR__."/storage/framework/cache", 0775, true);
  @mkdir(__DIR__."/storage/framework/views", 0775, true);
  @mkdir(__DIR__."/storage/framework/sessions", 0775, true);
  @mkdir(__DIR__."/bootstrap/cache", 0775, true);
  @chmod(__DIR__."/storage", 0775);
  @chmod(__DIR__."/bootstrap/cache", 0775);
  out("Permissions set for storage/ and bootstrap/cache");
  exit;
}

if ($steps === 'composer') {
  chdir(__DIR__);
  if (!file_exists('composer.phar')) {
    out("Downloading composer.phar ...");
    $composerUrl = "https://getcomposer.org/installer";
    $installer = @file_get_contents($composerUrl);
    if (!$installer) { out("Failed to download installer. Please run Composer from cPanel Terminal."); exit; }
    file_put_contents("composer-setup.php", $installer);
    out(shell_exec("php composer-setup.php 2>&1"));
    @unlink("composer-setup.php");
  }
  if (!file_exists('composer.phar')) { out("composer.phar not found. Abort."); exit; }
  out(shell_exec("php composer.phar install --no-dev --prefer-dist --optimize-autoloader 2>&1"));
  exit;
}

if ($steps === 'key') {
  chdir(__DIR__);
  out(shell_exec("php artisan key:generate 2>&1"));
  exit;
}

if ($steps === 'migrate') {
  chdir(__DIR__);
  out(shell_exec("php artisan migrate --force 2>&1"));
  exit;
}

if ($steps === 'done') {
  ?>
  <h3>All Set!</h3>
  <p>• Set Cron di cPanel:</p>
  <pre>* * * * * php <?php echo __DIR__; ?>/artisan schedule:run >> /dev/null 2>&1</pre>
  <p>• Buat admin user via phpMyAdmin (tabel users) atau via Terminal <code>php artisan tinker</code>.</p>
  <?php
  exit;
}
